unit stopwatch;
interface
uses hexdump;
type clock = longint;
procedure startclock(var c: clock);
function  stopclock(c: clock): real;
procedure wait(secs: real);
procedure milliwait(millisecs: word);

implementation

var timer_freq: longint;
  x, prevx: byte;
  diff: word;

function cyclecnt: byte; {counter in timer chip channel 0);}
   var c: word;
       cr: record
            clo: byte;
            chi: byte
           end absolute c;
begin
   inline ($FA); {CLI  disable interrupt}
   port[$43] := $06; {channel 0, latch present value, mode 3, binary}
   cr.clo := port[$40];
   cr.chi := port[$40];
   inline ($FB); {STI  enable interrupt};
   cyclecnt := hi(c);
end;

procedure milliwait(millisecs: word);
const debug=false;
var
    countdown: longint;
begin
    countdown := millisecs * timer_freq div 1000;
    if debug then writeln('countdown: ', countdown);
    x := cyclecnt;
    repeat
      prevx := x;
      x := cyclecnt;
      if x<prevx then diff := prevx - x

      else diff := word(prevx) + $100 - x;

      if debug then writeln ('prev: ', word_to_hex(prevx),
          '  x: ', word_to_hex(x), '  diff: ', word_to_hex(diff),
          '  countdown: ', countdown);
      dec (countdown, diff)
    until countdown <= 0;
end;


procedure startclock(var c: clock);
var ticks: longint absolute $0040:$006C;
begin
   c := ticks;
end;

function stopclock(c: clock): real;
var ticks: longint absolute $0040:$006C;
begin
  stopclock := (ticks - c) / 18.2;
end;



procedure wait(secs: real);
   var c: clock;
begin
   startclock(c);
   repeat
     begin end
   until stopclock(c) >= secs;
end;
begin
  timer_freq := round (3386360 / (1.418 * $100));
end.
